#!/bin/sh

#二进制文件路径
gecoosac_bin_path="/etc/gecoosac/ac_linux_arm64"
#运行端口
gecoosac_port=60650
#上传文件路径
gecoosac_upload="/etc/gecoosac/gecoosac_upload"
#数据库路径
gecoosac_dbpath="/etc/gecoosac/gecoosac_dbpath"
#是否验证token
gecoosac_token=1
#语言设置
gecoosac_lang=zh
#日志输出
gecoosac_log="/etc/gecoosac/gecoosac.log"


[ ! -d $gecoosac_upload ] && mkdir -p $gecoosac_upload
[ ! -d $gecoosac_dbpath ] && mkdir -p $gecoosac_dbpath



run() {
    $gecoosac_bin_path -p $gecoosac_port -f $gecoosac_upload -dbpath $gecoosac_dbpath -token $gecoosac_token -lang $gecoosac_lang >$gecoosac_log 2>&1
}

install() {

    # Add script to system autostart
    uci set firewall.auto_gecoosac=include
    uci set firewall.auto_gecoosac.type='script'
    uci set firewall.auto_gecoosac.path="/etc/gecoosac/auto_gecoosac.sh"
    uci set firewall.auto_gecoosac.enabled='1'
    uci commit firewall
 
}

case $1 in
    install)
        install
        ;;
    *)
        (run &)
        ;;
esac




